<?php
/**
* Auto detect language and currency
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate
*  @copyright 2017 idnovate
*  @license   See above
*/

class AutoLanguageCurrencyConfiguration extends ObjectModel
{
    public $id_autolanguagecurrency_configuration;
    public $countries;
    public $zones;
    public $language;
    public $currency;
    public $hide_language_selector;
    public $hide_currency_selector;
    public $catalog_mode;
    public $redirect_shop;
    public $redirect_url;
    public $position;
    public $active = false;
    public $id_shop;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'autolanguagecurrency_configuration',
        'primary' => 'id_autolanguagecurrency_configuration',
        'multilang' => false,
        'fields' => array(
            'countries' =>              array('type' => self::TYPE_STRING, 'size' => 1000),
            'zones' =>                  array('type' => self::TYPE_STRING, 'size' => 150),
            'language' =>               array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'currency' =>               array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'hide_currency_selector' => array('type' => self::TYPE_STRING, 'size' => 150),
            'hide_language_selector' => array('type' => self::TYPE_STRING, 'size' => 150),
            'catalog_mode' =>           array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'redirect_shop' =>          array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'redirect_url'=>            array('type' => self::TYPE_STRING, 'size' => 150),
            'position' =>               array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'active' =>                 array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'copy_post' => false),
            'id_shop' =>                array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'copy_post' => false),
            'date_add' =>               array('type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false),
            'date_upd' =>               array('type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false),
        ),
    );

    public function __construct($id = null)
    {
        parent::__construct($id);
    }

    public function add($autodate = true, $null_values = true)
    {
        $this->id_shop = ($this->id_shop) ? $this->id_shop : Context::getContext()->shop->id;
        $success = parent::add($autodate, $null_values);
        return $success;
    }

    public function toggleStatus()
    {
        parent::toggleStatus();
        return Db::getInstance()->execute('
        UPDATE `'._DB_PREFIX_.bqSQL($this->def['table']).'`
        SET `date_upd` = NOW()
        WHERE `'.bqSQL($this->def['primary']).'` = '.(int)$this->id);
    }

    public static function checkExceptions($country_code, $id_shop = 0)
    {
        $exceptions = Db::getInstance()->executeS(
            'SELECT c.`id_autolanguagecurrency_configuration`, c.`countries`, c.`zones`, c.`language`,
            c.`currency`, c.`hide_currency_selector`, c.`hide_language_selector`, c.`catalog_mode`, c.`redirect_url`, c.`redirect_shop`, c.`position`
            FROM `'._DB_PREFIX_.'autolanguagecurrency_configuration` c
            WHERE c.`id_shop` = '.(int)$id_shop.'
            AND c.`active` = 1 
            ORDER BY c.`position`;'
        );
        $result = array();
        $country = new Country(Country::getByIso($country_code));
        foreach ($exceptions as $exception) {
            $countries = explode(';', $exception['countries']);
            $zones = explode(';', $exception['zones']);
            if (in_array($country_code, $countries) || $exception['countries'] == 'all') {
                $result['language'] = Language::getIsoById($exception['language']);
                $currency = Currency::getCurrency($exception['currency']);
                $result['currency'] = $currency['iso_code'];
                $result['id'] = $exception['id_autolanguagecurrency_configuration'];
                $result['catalog_mode'] = $exception['catalog_mode'];
                $result['redirect_url'] = $exception['redirect_url'];
                $result['redirect_shop'] = $exception['redirect_shop'];
                return $result;
            }
            if (in_array(Country::getIdZone($country->id), $zones) || $exception['zones'] == 'all') {
                $result['language'] = Language::getIsoById($exception['language']);
                $currency = Currency::getCurrency($exception['currency']);
                $result['currency'] = $currency['iso_code'];
                $result['id'] = $exception['id_autolanguagecurrency_configuration'];
                $result['catalog_mode'] = $exception['catalog_mode'];
                $result['redirect_url'] = $exception['redirect_url'];
                $result['redirect_shop'] = $exception['redirect_shop'];
                return $result;
            }
        }
        return false;
    }
}
